/*
 * Decompiled with CFR 0.152.
 */
package com.farrellf.TelemetryGUI;

import com.farrellf.TelemetryGUI.BallPanel;
import com.farrellf.TelemetryGUI.ConfigurationLoader;
import com.farrellf.TelemetryGUI.Database;
import com.farrellf.TelemetryGUI.LineGraph;
import com.farrellf.TelemetryGUI.SerialConfigPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class TelemetryGUI
extends JFrame
implements ActionListener {
    Map<String, TelemetryGroup> groups;
    JPanel mainPanel;
    BallPanel ball;
    Database db;

    public TelemetryGUI(Database database) {
        this.db = database;
        this.groups = new HashMap<String, TelemetryGroup>();
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setDefaultCloseOperation(3);
        this.setTitle("Robot Telemetry");
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.add(this.mainPanel);
        this.ball = new BallPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        this.mainPanel.add((Component)this.ball, gbc);
        SerialConfigPanel serialConfig = new SerialConfigPanel(this.db);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 4;
        this.mainPanel.add((Component)serialConfig, gbc);
        new ConfigurationLoader(this);
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
        Timer timer = new Timer(20, this);
        timer.start();
    }

    public void addGroup(String groupName, int x, int y) {
        if (!this.groups.containsKey(groupName)) {
            TelemetryGroup tg = new TelemetryGroup(groupName);
            this.groups.put(groupName, tg);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = x;
            gbc.gridy = y;
            gbc.insets = new Insets(10, 10, 10, 10);
            gbc.fill = 2;
            gbc.anchor = 11;
            this.mainPanel.add((Component)tg, gbc);
        }
    }

    public void addGroupItem(String groupName, String itemName, String dbName, int min, int max, double factor, String df, String suffix, int value) {
        this.groups.get(groupName).addItem(itemName, dbName, min, max, factor, df, suffix, value);
    }

    public void setGroupItemValue(String groupName, String itemName, int value) {
        this.groups.get(groupName).getTelemetryItem(itemName).setValue(value);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (String groupName : this.groups.keySet()) {
            for (String groupItemName : this.groups.get((Object)groupName).items.keySet()) {
                String dbName = this.groups.get((Object)groupName).getTelemetryItem((String)groupItemName).dbName;
                this.setGroupItemValue(groupName, groupItemName, this.db.getLastValue(dbName));
            }
        }
        this.ball.setAngleX(this.db.getLastValue("AngleY") / 114);
        this.ball.setAngleY(this.db.getLastValue("AngleX") / -114);
    }

    private class TelemetryGroup
    extends JPanel {
        Map<String, TelemetryItem> items;
        GridBagConstraints gbc;
        int y = 0;

        public TelemetryGroup(String groupName) {
            this.setLayout(new GridBagLayout());
            this.gbc = new GridBagConstraints();
            this.gbc.insets = new Insets(10, 5, 10, 5);
            this.gbc.fill = 2;
            this.gbc.gridx = 0;
            this.gbc.gridy = this.y;
            this.items = new HashMap<String, TelemetryItem>();
            this.setBorder(new TitledBorder(new EtchedBorder(1, null, null), groupName, 4, 2, null, null));
        }

        public void addItem(String itemName, String dbName, int min, int max, double factor, String df, String suffix, int value) {
            if (!this.items.containsKey(itemName)) {
                TelemetryItem ti = new TelemetryItem(itemName, dbName, min, max, factor, df, suffix, value);
                this.add((Component)ti, this.gbc);
                ++this.gbc.gridy;
                this.items.put(itemName, ti);
            }
        }

        public TelemetryItem getTelemetryItem(String itemName) {
            return this.items.get(itemName);
        }
    }

    private class TelemetryItem
    extends JPanel
    implements MouseListener {
        DecimalFormat formattedDF;
        DecimalFormat rawDF;
        String suffix;
        String name;
        String dbName;
        int min;
        int max;
        double factor;
        JLabel title;
        JLabel rawValue;
        JLabel formattedValue;
        JSlider slider;
        GridBagConstraints gbc;

        public TelemetryItem(String name, String dbName, int min, int max, double factor, String df, String suffix, int value) {
            this.formattedDF = new DecimalFormat(df);
            this.rawDF = new DecimalFormat("+00000;-#");
            this.suffix = suffix;
            this.name = name;
            this.dbName = dbName;
            this.min = min;
            this.max = max;
            this.factor = factor;
            this.title = new JLabel(name);
            this.rawValue = new JLabel(this.rawDF.format(value));
            this.formattedValue = new JLabel(String.valueOf(this.formattedDF.format((double)value / factor)) + " " + suffix);
            this.slider = new JSlider();
            this.slider.setValue((int)((double)value / factor));
            this.slider.setMinimum(min);
            this.slider.setMaximum(max);
            this.slider.setPaintTicks(true);
            this.slider.setPaintLabels(true);
            this.slider.setMinorTickSpacing((max - min) / 10);
            this.slider.setMajorTickSpacing((max - min) / 2);
            this.setLayout(new GridBagLayout());
            this.gbc = new GridBagConstraints();
            this.gbc.insets = new Insets(3, 3, 3, 3);
            this.gbc.gridx = 0;
            this.gbc.gridy = 0;
            this.gbc.weightx = 1.0;
            this.title.setFont(new Font("Dialog", 1, 12));
            this.add((Component)this.title, this.gbc);
            this.gbc.gridx = 0;
            this.gbc.gridy = 1;
            this.gbc.weightx = 1.0;
            this.rawValue.setFont(new Font("Monospaced", 0, 12));
            this.add((Component)this.rawValue, this.gbc);
            this.gbc.gridx = 0;
            this.gbc.gridy = 2;
            this.gbc.weightx = 1.0;
            this.formattedValue.setFont(new Font("Monospaced", 0, 12));
            this.add((Component)this.formattedValue, this.gbc);
            this.gbc.gridx = 1;
            this.gbc.gridy = 0;
            this.gbc.gridheight = 3;
            this.gbc.weightx = 0.0;
            this.add((Component)this.slider, this.gbc);
            this.addMouseListener(this);
        }

        public void setValue(int value) {
            this.rawValue.setText(this.rawDF.format(value));
            this.formattedValue.setText(String.valueOf(this.formattedDF.format((double)value / this.factor)) + " " + this.suffix);
            this.slider.setValue((int)((double)value / this.factor));
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            new LineGraph(this.name, TelemetryGUI.this.db.getList(this.dbName), this.min, this.max, this.factor, 500);
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

