/*
 * Decompiled with CFR 0.152.
 */
package com.farrellf.TelemetryGUI;

import com.farrellf.TelemetryGUI.Database;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Scanner;

public class SerialPortListener
implements Runnable {
    private Database db;
    private SerialPort rs232;
    private InputStream rs232istream;
    private Scanner rs232scanner;
    private String line;
    private String value;
    private int number;

    public SerialPortListener(Database db) {
        this.db = db;
    }

    public Object[] getSerialPorts() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration ports = CommPortIdentifier.getPortIdentifiers();
        while (ports.hasMoreElements()) {
            CommPortIdentifier port = (CommPortIdentifier)ports.nextElement();
            if (port.getPortType() != 1) continue;
            list.add(port.getName());
        }
        return list.toArray();
    }

    public Boolean establishConnection(String port, int baudRate) {
        try {
            this.rs232 = (SerialPort)CommPortIdentifier.getPortIdentifier((String)port).open("Robot Telemetry", 20000);
            this.rs232.setSerialPortParams(baudRate, 8, 1, 0);
            this.rs232istream = this.rs232.getInputStream();
            this.rs232scanner = new Scanner(this.rs232istream);
            System.out.println("Connected to " + port + " at " + baudRate + " baud.");
            return true;
        }
        catch (Exception e) {
            System.err.println("Error setting up serial communications with port " + port + ".");
            System.err.println(e.getClass().toString());
            return false;
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.line = this.rs232scanner.nextLine();
                    if (this.line.length() == 65) {
                        this.line = this.line.substring(3);
                    }
                    if (this.line.length() != 62) continue;
                    try {
                        this.value = this.line.substring(12, 18);
                        this.number = Integer.parseInt(this.value);
                        this.db.addValue(this.line.substring(0, this.line.indexOf(" ")), this.number);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                System.err.println("One or more errors occured.");
                System.err.println(e.getClass().toString());
                continue;
            }
            break;
        }
    }
}

