/*
 * Decompiled with CFR 0.152.
 */
package com.farrellf.TelemetryGUI;

import com.farrellf.TelemetryGUI.Database;
import com.farrellf.TelemetryGUI.SerialPortListener;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SerialConfigPanel
extends JPanel
implements MouseListener {
    JLabel portLabel;
    JComboBox portString;
    JLabel baudRateLabel;
    JComboBox baudRateSelection;
    JButton applyButton;
    String[] baudRates;
    SerialPortListener rs232;
    Thread rs232thread;

    public SerialConfigPanel(Database db) {
        this.rs232 = new SerialPortListener(db);
        this.rs232thread = new Thread(this.rs232);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.portLabel = new JLabel("Serial Port:");
        this.portLabel.setFont(new Font("Dialog", 1, 12));
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 0, 10, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.portLabel, gbc);
        this.portString = new JComboBox<Object>(this.rs232.getSerialPorts());
        this.portString.setEditable(true);
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 0, 10, 5);
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.add((Component)this.portString, gbc);
        this.baudRateLabel = new JLabel("Baud Rate:");
        this.baudRateLabel.setFont(new Font("Dialog", 1, 12));
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 30, 10, 5);
        gbc.gridx = 2;
        gbc.gridy = 0;
        this.add((Component)this.baudRateLabel, gbc);
        this.baudRates = new String[]{"1382400", "921600", "460800", "230400", "115200", "57600", "38400", "19200", "9600"};
        this.baudRateSelection = new JComboBox<String>(this.baudRates);
        this.baudRateSelection.setSelectedIndex(1);
        this.baudRateSelection.setEditable(true);
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 0, 10, 5);
        gbc.gridx = 3;
        gbc.gridy = 0;
        this.add((Component)this.baudRateSelection, gbc);
        this.applyButton = new JButton("Apply");
        this.applyButton.setFont(new Font("Dialog", 1, 12));
        this.applyButton.addMouseListener(this);
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 30, 10, 5);
        gbc.gridx = 4;
        gbc.gridy = 0;
        this.add((Component)this.applyButton, gbc);
        if (this.rs232.getSerialPorts().length == 1 && this.rs232.establishConnection((String)this.rs232.getSerialPorts()[0], Integer.parseInt((String)this.baudRateSelection.getSelectedItem())).booleanValue()) {
            this.rs232thread.start();
            this.applyButton.setEnabled(false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.applyButton.isEnabled()) {
            return;
        }
        if (this.rs232.establishConnection((String)this.portString.getSelectedItem(), Integer.parseInt((String)this.baudRateSelection.getSelectedItem())).booleanValue()) {
            this.rs232thread.start();
            this.applyButton.setEnabled(false);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

