/*
 * Decompiled with CFR 0.152.
 */
package com.farrellf.TelemetryGUI;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.UIManager;

public class LineGraph
extends JFrame
implements ActionListener {
    Timer timer;

    public LineGraph(String windowName, List<Integer> list, int min, int max, double factor, int maxLength) {
        this.setDefaultCloseOperation(2);
        this.setTitle("Line Graph: " + windowName);
        this.setSize(800, 335);
        this.setLocation(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().width - this.getWidth(), GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().height - this.getHeight() + 40);
        this.setAlwaysOnTop(true);
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Chart c = new Chart(list, min, max, factor, maxLength);
        this.add(c);
        this.setVisible(true);
        this.timer = new Timer(20, this);
        this.timer.start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.repaint();
    }

    private class Chart
    extends JPanel {
        List<Integer> list;
        double min;
        double max;
        double factor;
        int maxLength;

        public Chart(List<Integer> list, int min, int max, double factor, int maxLength) {
            this.list = list;
            this.min = min;
            this.max = max;
            this.factor = factor;
            this.maxLength = maxLength != 0 ? maxLength : Integer.MAX_VALUE;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            double panelWidth = this.getWidth();
            double panelHeight = this.getHeight();
            double listSize = this.list.size();
            g.setColor(Color.LIGHT_GRAY);
            g.drawLine(0, (int)panelHeight / 2, (int)panelWidth, (int)panelHeight / 2);
            g.setColor(Color.BLACK);
            int i = listSize > (double)this.maxLength ? (int)listSize - this.maxLength : 1;
            while ((double)i < listSize) {
                double x2;
                double x1;
                if (listSize > (double)this.maxLength) {
                    x1 = ((double)(i - 1) - listSize + (double)this.maxLength) / (double)this.maxLength * panelWidth;
                    x2 = ((double)i - listSize + (double)this.maxLength) / (double)this.maxLength * panelWidth;
                } else {
                    x1 = (double)(i - 1) / listSize * panelWidth;
                    x2 = (double)i / listSize * panelWidth;
                }
                double y1 = panelHeight - ((double)this.list.get(i - 1).intValue() / this.factor - this.min) * (panelHeight / (this.max - this.min));
                double y2 = panelHeight - ((double)this.list.get(i).intValue() / this.factor - this.min) * (panelHeight / (this.max - this.min));
                g.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
                ++i;
            }
        }
    }
}

