/*
 * Decompiled with CFR 0.152.
 */
package com.farrellf.TelemetryGUI;

import com.farrellf.TelemetryGUI.TelemetryGUI;
import java.io.File;
import java.util.Scanner;

public class ConfigurationLoader {
    File f;
    Scanner s;
    TelemetryGUI gui;

    public ConfigurationLoader(TelemetryGUI gui) {
        this.gui = gui;
        try {
            this.f = new File("config.txt");
            this.s = new Scanner(this.f);
        }
        catch (Exception e) {
            System.err.println("Unable to open the configuration file at " + this.f.getAbsolutePath());
        }
        while (this.s.hasNext()) {
            String line = this.s.nextLine();
            try {
                String groupName;
                String[] chunks;
                if (line.length() == 0 || line.startsWith("#")) continue;
                if (line.startsWith("Group:")) {
                    line = line.substring(6);
                    chunks = line.split(",");
                    groupName = chunks[0].trim();
                    int x = Integer.parseInt(chunks[1].trim());
                    int y = Integer.parseInt(chunks[2].trim());
                    gui.addGroup(groupName, x, y);
                    System.out.println("Adding Group: " + groupName + ", " + x + ", " + y);
                    continue;
                }
                if (!line.startsWith("Item:")) continue;
                line = line.substring(5);
                chunks = line.split(",");
                groupName = chunks[0].trim();
                String itemName = chunks[1].trim();
                String dbName = chunks[2].trim();
                int min = Integer.parseInt(chunks[3].trim());
                int max = Integer.parseInt(chunks[4].trim());
                double factor = Double.parseDouble(chunks[5].trim());
                String df = chunks[6].trim();
                String suffix = chunks[7].trim();
                int defaultValue = Integer.parseInt(chunks[8].trim());
                gui.addGroupItem(groupName, itemName, dbName, min, max, factor, df, suffix, defaultValue);
                System.out.println("Adding Item: " + groupName + ", " + itemName + ", " + dbName + ", " + min + ", " + max + ", " + factor + ", " + df + ", " + suffix + ", " + defaultValue);
            }
            catch (Exception e) {
                System.err.println("Error parsing configuration file line: " + line);
            }
        }
    }
}

