/*
 * Decompiled with CFR 0.152.
 */
package com.farrellf.TelemetryGUI;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class BallPanel
extends JPanel {
    private double angleX;
    private double angleY;
    private final int XOFF = 20;
    private final int YOFF = 25;
    private final int CIRCLE_WIDTH = 240;
    private final int CIRCLE_HEIGHT = 240;

    public BallPanel() {
        this.setSize(280, 290);
        this.setMinimumSize(new Dimension(280, 290));
        this.setMaximumSize(new Dimension(280, 290));
        this.setPreferredSize(new Dimension(280, 290));
        this.angleX = 0.0;
        this.angleY = 0.0;
    }

    public void setAngleX(double d) {
        this.angleX = d;
        this.repaint();
    }

    public void setAngleY(double d) {
        this.angleY = d;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.BLUE);
        g2.drawOval(20, 25, 240, 240);
        g2.setColor(Color.RED);
        int ellipseHeight = (int)(Math.sin(Math.toRadians(this.angleX)) * 240.0);
        if (this.angleX >= 0.0 && this.angleX <= 90.0) {
            g2.drawArc(20, 145 - ellipseHeight / 2, 240, ellipseHeight, 0, 180);
        } else if (this.angleX < 0.0 && this.angleX >= -90.0) {
            g2.drawArc(20, 145 - (ellipseHeight *= -1) / 2, 240, ellipseHeight, 180, 180);
        }
        g2.setColor(Color.RED);
        int ellipseWidth = (int)(Math.sin(Math.toRadians(this.angleY)) * 240.0);
        if (this.angleY >= 0.0 && this.angleY <= 90.0) {
            g2.drawArc(140 - ellipseWidth / 2, 25, ellipseWidth, 240, 90, 180);
        } else if (this.angleY < 0.0 && this.angleY >= -90.0) {
            g2.drawArc(140 - (ellipseWidth *= -1) / 2, 25, ellipseWidth, 240, 270, 180);
        }
    }
}

